init -10 python:
    
    ## The Catalog Button ##
    def catalog_button(**kwargs):
        try:
            if player_credits > 0:
                ui.frame(xalign = 0.5, yalign = 0.0)
                ui.vbox()
                ui.textbutton("Catalog", clicked=ui.callsinnewcontext('catalog'))
                ui.close()
                
        except NameError:
            pass
    
    ## The Catalog Screen ##
    def catalog_screen_map(**kwargs):
        ui.frame(xalign = 0.5, yalign = 0.5)
        
        ui.vbox()
        
        ui.text("Credits: %d" % player_credits, xalign=0.5)
        
        ui.hbox()
        
        ui.vbox()
        
        if player_credits > 0 and not inventory_net:
            ui.imagebutton('ui/net.png', 'ui/net_h.png', clicked=ui.returns('net'))
        else:
            ui.imagebutton('ui/net_u.png', 'ui/net_u.png')
            
        if player_credits > 0 and not inventory_chainsaw:
            ui.imagebutton('ui/chainsaw.png', 'ui/chainsaw_h.png', clicked=ui.returns('chainsaw'))
        else:
            ui.imagebutton('ui/chainsaw_u.png', 'ui/chainsaw_u.png')
            
        ui.close()
        
        ui.null(20)
        
        ui.vbox()
        
        if player_credits > 0 and not inventory_welding:
            ui.imagebutton('ui/welding.png', 'ui/welding_h.png', clicked=ui.returns('welding'))
        else:
            ui.imagebutton('ui/welding_u.png', 'ui/welding_u.png')
          
        ui.hbox()
        
        if player_credits > 0 and not inventory_yacht:
            ui.imagebutton('ui/yacht.png', 'ui/yacht_h.png', clicked=ui.returns('yacht'))
        else:
            ui.imagebutton('ui/yacht_u.png', 'ui/yacht_u.png')
        
        if player_credits > 0 and not inventory_scuba:
            ui.imagebutton('ui/scuba.png', 'ui/scuba_h.png', clicked=ui.returns('scuba'))
        else:
            ui.imagebutton('ui/scuba_u.png', 'ui/scuba_u.png')
        
        ui.close()
        ui.close()
        
        ui.close()
        
        ui.null(height=10)
        ui.textbutton("Cancel", clicked=ui.returns('x'), xalign=0.5)
        ui.close()
       
    ## Old Text-Based Catalog ##
    def catalog_screen(**kwargs):
        ui.frame(xalign = 0.5, yalign = 0.5)
        ui.vbox()
        ui.text("Credits: %d" % player_credits)
        
        if player_credits > 0 and not inventory_welding:
            ui.textbutton("ACME All Purpose Welding Kit", clicked=ui.returns('welding'))
        else:
            ui.textbutton("ACME All Purpose Welding Kit")
        
        if player_credits > 0 and not inventory_yacht:
            ui.textbutton("Yacht", clicked=ui.returns('yacht'))
        else:
            ui.textbutton("Yacht")
        
        if player_credits > 0 and not inventory_scuba:
            ui.textbutton("SCUBA Gear", clicked=ui.returns('scuba'))
        else:
            ui.textbutton("SCUBA Gear")
            
        if player_credits > 0 and not inventory_net:
            ui.textbutton("Net", clicked=ui.returns('net'))
        else:
            ui.textbutton("Net")
         
        if player_credits > 0 and not inventory_chainsaw:
            ui.textbutton("Chainsaw", clicked=ui.returns('chainsaw'))
        else:
            ui.textbutton("Chainsaw")
            
        ui.textbutton("Cancel", clicked=ui.returns('x'))
        ui.close()
        
    ## Define the Screens in Ren'Py ##
    renpy.define_screen('catalog_screen', catalog_screen_map, 'True', '10')
    renpy.define_screen('catalog_button', catalog_button, 'False', '9')
    
## Catalog Loop ##
label catalog:
    
    python:
        choice = renpy.call_screen('catalog_screen')
        
        if choice == 'welding':
            player_credits -= 1
            inventory_welding = True
            renpy.jump('catalog')
        
        elif choice == 'yacht':
            player_credits -= 1
            inventory_yacht = True
            renpy.jump('catalog')
            
        elif choice == 'scuba':
            player_credits -= 1
            inventory_scuba = True
            renpy.jump('catalog')
            
        elif choice == 'net':
            player_credits -= 1
            inventory_net = True
            renpy.jump('catalog')
            
        elif choice == 'chainsaw':
            player_credits -= 1
            inventory_chainsaw = True
            renpy.jump('catalog')
            
        else:
            pass
        
    return 
